<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kurirs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transaksi_id')->constrained(
                table: 'transaksis',
                indexName: 'kurir_transaksi_id'
            )->onDelete('cascade');
            $table->foreignId('karyawan_id')->constrained(
                table: 'karyawans',
                indexName: 'kurir_karyawan_id'
            )->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kurirs');
    }
};
